<!DOCTYPE html>
<html lang="en">
	<!--begin::Head-->
	<head>
        <x:core::metadata.full />

		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />

        <link rel="shortcut icon" href="{{ theme()->publicPath('media/logos/favicon.ico') }}" />
		<!--begin::Fonts(mandatory for all pages)-->
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />

        <!--begin::Css-->

            <!-- begin::Css App Libraries -->
            <x:core::vite.styles type="library" />

            <!-- begin::Css Theme Libraries -->
            <link href="{{ theme()->publicPath('plugins/global/plugins.bundle.css') }}?v4" rel="stylesheet" type="text/css" />

            <!-- begin::Css App Modules -->
            <x:core::vite.styles type="module" />

            <!-- begin::Css Theme Scripts -->
            <link href="{{ theme()->publicPath('css/style.bundle.css') }}?v4" rel="stylesheet" type="text/css" />

            <!-- begin::Css App Scripts -->
            <x:core::vite.styles type="script" />

		<!--end::Css-->

        <meta name="csrf-token" content="{{ csrf_token() }}">

        @yield('css')
	</head>
	<!--end::Head-->
	<!--begin::Body-->
	<body data-kt-app-sidebar-minimize="on" id="kt_app_body" data-kt-app-layout="dark-sidebar" data-kt-app-header-fixed="true" data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true" data-kt-app-sidebar-hoverable="true" data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true" data-kt-app-sidebar-push-footer="true" data-kt-app-toolbar-enabled="true" class="app-default">

		<!--begin::App-->
		<div class="d-flex flex-column flex-root app-root" id="kt_app_root">
			<!--begin::Page-->
			<div class="app-page flex-column flex-column-fluid" id="kt_app_page">
                @include(theme()->partials('header'))
				<!--begin::Wrapper-->
				<div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
                    @include(theme()->partials('sidebar'))
					<!--begin::Main-->
					<div class="app-main flex-column flex-row-fluid" id="kt_app_main">
						<!--begin::Content wrapper-->
						<div class="d-flex flex-column flex-column-fluid">
                            @yield('page-header')
							<!--begin::Content-->
							<div id="kt_app_content" class="app-content flex-column-fluid">
								<!--begin::Content container-->
								<div id="kt_app_content_container" style="padding: 0 30px" class="/*app-container container-xxl*/">
                                    @if(isset($element))
                                        <x:content::top.edit :element="$element" />
                                    @endif
                                    @include(theme()->partials('message'))
                                    @yield('content')
								</div>
								<!--end::Content container-->
							</div>
							<!--end::Content-->
						</div>
						<!--end::Content wrapper-->
						<!--begin::Footer-->
						<div id="kt_app_footer" class="app-footer">
							<!--begin::Footer container-->
							<div class="app-container container-fluid d-flex flex-column flex-md-row flex-center flex-md-stack py-3">
								<!--begin::Copyright-->
								<div class="text-dark order-2 order-md-1">
									<span class="text-muted fw-semibold me-1">2024&copy;</span>
									<a href="#" target="_blank" class="text-gray-800 text-hover-primary">Accounting</a>
								</div>
								<!--end::Copyright-->
								<!--begin::Menu-->
								<ul class="menu menu-gray-600 menu-hover-primary fw-semibold order-1">
									<li class="menu-item">
										<a href="/" target="_blank" class="menu-link px-2">accounting</a>
									</li>
								</ul>
								<!--end::Menu-->
							</div>
							<!--end::Footer container-->
						</div>
						<!--end::Footer-->
					</div>
					<!--end:::Main-->
				</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::App-->
		<!--begin::Scrolltop-->
		<div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
			<!--begin::Svg Icon | path: icons/duotune/arrows/arr066.svg-->
			<span class="svg-icon">
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor" />
					<path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor" />
				</svg>
			</span>
			<!--end::Svg Icon-->
		</div>
		<!--end::Scrolltop-->

		<!--begin::Javascript-->
            <script>var hostUrl = "/vendor/viartas-themes/metronic/assets/";</script>

            <!-- begin::Javascript App Libraries -->
            <x:core::vite.scripts type="library" />

            <!-- begin::Javascript Themes Libraries -->
            <script src="{{ theme()->publicPath('plugins/global/plugins.bundle.js?v21') }}"></script>

            <!-- begin::Javascript App Modules -->
            <x:core::vite.scripts type="module" />

            <!-- begin::Javascript Themes Scripts -->
            <script src="{{ theme()->publicPath('js/scripts.bundle.js?21') }}"></script>

            {{--<script src="{{ theme()->publicPath('js/custom/apps/ecommerce/catalog/save-product.js') }}"></script>--}}
            <script src="{{ theme()->publicPath('js/widgets.bundle.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/widgets.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/apps/chat/chat.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/utilities/modals/upgrade-plan.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/utilities/modals/create-campaign.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/utilities/modals/create-app.js') }}"></script>
            <script src="{{ theme()->publicPath('js/custom/utilities/modals/users-search.js') }}"></script>

            <!-- begin::Javascript App Scripts -->
            <x:core::vite.scripts type="script" />

            @stack('push-js')
            @yield('section-js')
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html>
