<?php

namespace ViartasThemes\Florial\Providers;

use ViartasCore\Core\Providers\BaseThemeServiceProvider;
use ViartasCore\Auth\Controllers\LoginController;
use ViartasThemes\Florial\Modules\Auth\LoginController as LoginControllerFlorial;

class ThemeServiceProvider extends BaseThemeServiceProvider
{
    /**
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @var string
     */
    public string $application = 'web';

    /**
     * @return string[]
     */
    public function controllers(): array
    {
        return [
            LoginController::class => LoginControllerFlorial::class,
        ];
    }

    public function views(): array
    {
        return [
            'web.auth.login' => 'theme.web.modules.auth.login',
        ];
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [

        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'web.*' => [
                [
                    'vendor' => 'viartas-themes/florial',
                    'file' => 'resources/css/app.css',
                    'type' => 'script', //library, module, script
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function disabledNodePackages(): array
    {
        return [
            /*'accounting.*' => [
                'viartas-js/jquery',
            ]*/
        ];
    }
}
