<?php

namespace ViartasSupport\Number;

use Illuminate\Contracts\Database\Eloquent\Castable;
use \Illuminate\Testing\Exceptions\InvalidArgumentException;
use Stringable;
use ViartasSupport\Number\Casts\NumberCast;

class Number implements Stringable, Castable
{
    /**
     * @var string|float|int
     */
    public string|float|int $value;

    /**
     * @param Number|string|int|float|null $number
     */
    public function __construct(Number|string|int|float|null $number = 0)
    {
        $this->value($number ?? 0);
    }

    /**
     * @param Number|string|int|float $number
     * @param int $scale
     * @return $this
     */
    public function add(Number|string|int|float $number = 0, int $scale = 2): static
    {
        return new static(
            bcadd(
                $this->value,
                new static($number),
                $scale
            )
        );
    }

    /**
     * @param Number|string|int|float $number
     * @param int $scale
     * @return $this
     */
    public function sub(Number|string|int|float $number = 0, int $scale = 2): static
    {
        return new static(
            bcsub(
                $this->value,
                new static($number),
                $scale
            )
        );
    }

    /**
     * @param Number|string|int|float $number
     * @return Number
     */
    public function value(Number|string|int|float $number = 0): static
    {
        if ($number instanceof static) {
            $number = $number->value;
        }

        if (!is_numeric($number)) {
            throw new InvalidArgumentException(
                __("[{$number}] must be numeric")
            );
        }

        $this->value = $number;

        return $this;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->value;
    }

    /**
     * @param array $arguments
     * @return string
     */
    public static function castUsing(array $arguments): string
    {
        return NumberCast::class;
    }
}
