<?php

namespace ViartasSupport\Number\Providers;

use ViartasCore\Core\Providers\BasePackageServiceProvider;
use ViartasSupport\Number\Number;

class PackageServiceProvider extends BasePackageServiceProvider
{
    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {
        $schedule->command('example3:command')->everyMinute();
    }

    /**
     * @return void
     */
    public function register(): void
    {
        $this->app->bind("number", function () {
            return new Number();
        });

        parent::register();
    }
}
