<?php

namespace ViartasSupport\Number\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;
use ViartasSupport\Number\Number;

class NumberCast implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param Model $model
     * @param string $key
     * @param mixed $value
     * @param array<string, mixed> $attributes
     * @return Number
     */
    public function get(Model $model, string $key, mixed $value, array $attributes): Number
    {
        return new Number($value);
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  array<string, mixed>  $attributes
     */
    public function set(Model $model, string $key, mixed $value, array $attributes): string
    {
        if ($value instanceof Number) {
            $value = $value->value;
        }

        return $value;
    }
}
