<?php

namespace ViartasShop\Products\Models\Accounting;

use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\DefinesAsCacheItem;
use ViartasCore\Core\Traits\HasMetaTags;
use ViartasSupport\Number\Number;

class Product extends BaseModel
{
    use DefinesAsCacheItem, HasMetaTags;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'content', 'slug',
        'user_id', 'product_category_id', 'model_id',
        'stock', 'price',
        'weight', 'length', 'width', 'height',
        'layout',
        'yop',
        'is_visible',
    ];

    protected $casts = [
        'price' => Number::class,
        'stock' => Number::class,
    ];

    /**
     * @var string
     */
    protected string $module = 'products';

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var string
     */
    protected string $element_title = 'Product';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'title'; //workaround
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        $config = [
            'edit' => $this->menuItem(__('Main settings'), $this->routeEdit()),
            'inventory' => $this->menuItem(__('Inventory'), $this->routeEdit()),
            'attributes' => $this->menuItem(__('Attributes'), $this->routeEdit()),
            'upload_documents' => $this->menuItem(__('Upload documents'), $this->routeEdit()),
            'documents' => $this->menuItem(__('Documents'), $this->routeEdit()),
            'reviews' => $this->menuItem(__('Reviews'), $this->routeEdit()),
            'activity' => $this->menuItem(__('Activity'), $this->routeEdit()),
        ];

        if ($this->usesMedia()) {
            $config['upload_images'] = $this->menuItem(__('Upload images'), $this->routeUploadImages());
            $config['images'] = $this->menuItem(__('Images'), $this->routeUploadImages());
        }

        return $config;
    }
}
