<?php

namespace ViartasShop\Products\Drivers\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use ViartasCore\Core\Contracts\RouteGuesserContract;
use ViartasCore\Core\Facades\Viartas;
use ViartasShop\Products\Models\Accounting\Product;

class RouteGuesser implements RouteGuesserContract
{
    /**
     * @var int
     */
    protected int $priority = 200;

    /**
     * @param Request $request
     * @return \Illuminate\Foundation\Application|View|Factory|Application|int|Model
     */
    public function guessRoute(Request $request): \Illuminate\Foundation\Application|View|Factory|Application|int|Model
    {
        $slugLastSegment = Viartas::driver()->app()->getSlugLastSegment();
        $slug = Viartas::driver()->app()->getSlug();

        $product = Product::FindBySlug($slugLastSegment);

        if (!$product) {
            return 404;
        }

        $productSlug = $this->generateRoute($product);

        if ($productSlug !== $slug) {
            return 404;
        }

        return $product->view();
    }

    /**
     * @param Model $model
     * @return string
     */
    public function generateRoute(Model $model): string
    {
        return $model->generateRoute();
    }

    /**
     * @return int
     */
    public function priority(): int
    {
        return $this->priority;
    }
}
