<?php


use ViartasShop\Products\Controllers\Accounting\ProductsController;

Route::prefix('products')->group(function () {
    Route::get('/', [ProductsController::class, 'index'])->name('products.index');
    Route::get('/create', [ProductsController::class, 'create'])->name('products.create');
    Route::post('/create', [ProductsController::class, 'store'])->name('products.create');
    Route::get('/{id}/edit', [ProductsController::class, 'edit'])->name('products.edit');
    Route::post('/{id}/edit', [ProductsController::class, 'update'])->name('products.edit');
    Route::patch('/{id}/edit', [ProductsController::class, 'updateOneField'])->name('products.edit');
    Route::post('/{id}/destroy', [ProductsController::class, 'destroy'])->name('products.destroy');
    Route::get('/{id}/upload/images', [ProductsController::class, 'uploadImages'])->name('products.upload.images');
});
