<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('product_category_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('model_id')->nullable()->constrained()->nullOnDelete();
            $table->string('code')->nullable()->index();
            $table->jsonb('title');
            $table->jsonb('content');
            $table->jsonb('slug');
            $table->string('layout')->nullable()->index();
            $table->decimal('price', 64, 18)->nullable()->index();
            $table->decimal('stock', 64, 18)->nullable()->index();
            $table->decimal('weight', 64, 18)->nullable()->index();
            $table->decimal('width', 64, 18)->nullable()->index();
            $table->decimal('height', 64, 18)->nullable()->index();
            $table->decimal('length', 64, 18)->nullable()->index();
            $table->dateTime('yop')->nullable()->index();
            $table->boolean('is_visible')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
