<?php

namespace ViartasShop\ProductCategories\Providers;

use ViartasCore\Core\Providers\BasePackageServiceProvider;
use ViartasCore\Core\Traits\HasRoutes;
use ViartasShop\ProductCategories\Drivers\Accounting\RouteGuesser;

class PackageServiceProvider extends BasePackageServiceProvider
{
    use HasRoutes;

    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @return RouteGuesser
     */
    public function routeGuesserClass(): RouteGuesser
    {
        return new RouteGuesser();
    }

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {
        $schedule->command('example3:command')->everyMinute();
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [
            'accounting.product-categories.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.product-categories.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.product-categories.attributes-order' => [
                [
                    'vendor' => 'viartas-js/nestable',
                    'file' => 'resources/js/nestable.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ],
            ],

            'accounting.product-categories.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'accounting.product-categories.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],

            'accounting.product-categories.attributes-order' => [
                [
                    'vendor' => 'viartas-js/nestable',
                    'file' => 'resources/css/nestable.css',
                    'type' => 'module', //library, module, script
                ],
            ],
        ];
    }
}
