<?php

namespace ViartasShop\ProductCategories\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\Pivot;

class AttributeProductCategory extends Pivot
{
    /**
     * @var string
     */
    protected $table = 'attribute_product_category';

    /**
     * @var string[]
     */
    protected $fillable = [
        'attribute_id', 'product_category_id', 'sort',
        'is_visible_in_product', 'is_visible_in_category',
        'is_filterable_lg', 'is_filterable_sm',
    ];

    /**
     * @var string[]
     */
    protected $casts = [
        'sort' => 'integer',
        'is_visible_in_product' => 'boolean',
        'is_visible_in_category' => 'boolean',
        'is_filterable_lg' => 'boolean',
        'is_filterable_sm' => 'boolean',
    ];
}
