<?php

namespace ViartasShop\ProductCategories\Forms\Accounting;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use Illuminate\Database\Eloquent\Collection;
use ViartasCore\Core\Models\Role;
use ViartasShop\ProductCategories\Models\Accounting\ProductCategory;

class AttributesSettingsForm extends Form
{
    private ProductCategory $category;

    public function __construct()
    {
        $this->category = ProductCategory::findOrFail(request()->route('id'));
        parent::__construct();
    }
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    '_method' => 'POST',
                    'route' => 'accounting.product-categories.attributes-settings',
                    'routeAttributes' => [
                        'id' => request()->route('id')
                    ],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.product-categories.attributes-settings',
                    'routeAttributes' => [
                        'id' => request()->route('id')
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        $response = [];

        foreach ($this->category->attrs()->orderByPivot('sort')->get() as $attribute) {

            $response[$attribute->tag] = [
                'settings['.$attribute->id.'][is_visible_in_product]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => [
                        '1' => __('Visible in product'),
                    ],
                ],
                'settings['.$attribute->id.'][is_visible_in_category]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => [
                        '1' => __('Visible in category'),
                    ],
                ],
                'settings['.$attribute->id.'][is_filterable_lg]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => [
                        '1' => __('Filterable on desktop'),
                    ],
                ],
                'settings['.$attribute->id.'][is_filterable_sm]' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'options' => [
                        '1' => __('Filterable on mobile'),
                    ],
                ],
                'save_'.$attribute->tag => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        $response = [];

        foreach ($this->category->attrs()->orderByPivot('sort')->get() as $attribute) {
            $response[$attribute->tag] = [
                'title' =>  $attribute->title,
                'layout' => Group::CARD,
                'size' => 4,
            ];
        }

        return $response;
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
