<?php

namespace ViartasShop\ProductCategories\Drivers\Accounting;

use Closure;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use ViartasCore\Core\Contracts\RouteGuesserContract;
use ViartasCore\Core\Facades\Viartas;
use ViartasShop\ProductCategories\Models\Accounting\ProductCategory;

class RouteGuesser implements RouteGuesserContract
{
    /**
     * @var int
     */
    protected int $priority = 100;

    /**
     * @param Request $request
     * @return \Illuminate\Foundation\Application|View|Factory|Application|int|Model
     */
    public function guessRoute(Request $request): \Illuminate\Foundation\Application|View|Factory|Application|int|Model
    {
        $slugLastSegment = Viartas::driver()->app()->getSlugLastSegment();
        $slug = Viartas::driver()->app()->getSlug();

        $category = ProductCategory::FindBySlug($slugLastSegment);

        if (!$category) {
            return 404;
        }

        $categorySlug = $this->generateRoute($category);

        if ($categorySlug !== $slug) {
            return 404;
        }

        return $category;
    }

    /**
     * @param Model $model
     * @return string
     */
    public function generateRoute(Model $model): string
    {
        return $model->generateRoute();
    }

    /**
     * @return int
     */
    public function priority(): int
    {
        return $this->priority;
    }
}
