<?php

use ViartasShop\ProductCategories\Controllers\Accounting\ProductCategoriesController;

Route::prefix('product-categories')->group(function () {
    Route::get('/', [ProductCategoriesController::class, 'index'])->name('product-categories.index');
    Route::get('/create', [ProductCategoriesController::class, 'create'])->name('product-categories.create');
    Route::post('/create', [ProductCategoriesController::class, 'store'])->name('product-categories.create');
    Route::get('/{id}/edit', [ProductCategoriesController::class, 'edit'])->name('product-categories.edit');
    Route::post('/{id}/edit', [ProductCategoriesController::class, 'update'])->name('product-categories.edit');
    Route::patch('/{id}/edit', [ProductCategoriesController::class, 'updateOneField'])->name('product-categories.edit');
    Route::get('/{id}/attributes', [ProductCategoriesController::class, 'attributes'])->name('product-categories.attributes');
    Route::post('/{id}/attributes', [ProductCategoriesController::class, 'assignAttributes'])->name('product-categories.attributes');
    Route::get('/{id}/attributes/settings', [ProductCategoriesController::class, 'attributesSettings'])->name('product-categories.attributes-settings');
    Route::post('/{id}/attributes/settings', [ProductCategoriesController::class, 'attributesSettingsSave'])->name('product-categories.attributes-settings');
    Route::get('/{id}/attributes/order', [ProductCategoriesController::class, 'attributesOrder'])->name('product-categories.attributes-order');
    Route::post('/{id}/attributes/order', [ProductCategoriesController::class, 'attributesOrderSave'])->name('product-categories.attributes-order');
    Route::post('/{id}/destroy', [ProductCategoriesController::class, 'destroy'])->name('product-categories.destroy');
    Route::get('/{id}/upload/images', [ProductCategoriesController::class, 'uploadImages'])->name('product-categories.upload.images');
});
