@extends(theme()->layout())
@section('content')
    <div class="row">
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs nav-pills flex-row border-0 flex-md-column me-5 mb-3 mb-md-0 fs-6 min-w-lg-200px">
                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributes()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributes()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Attributes') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesSettings()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesSettings()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Settings') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesOrder()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesOrder()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Order') }}</span>
                                </span>
                            </a>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-md-10 remove-mt">
            <form action="{{ $element->routeAttributes()->getRoutePath() }}" method="post">
                @csrf
                <div data-kt-ecommerce-catalog-add-product="auto-options">
                    <div id="kt_ecommerce_add_product_options">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{ __('Assign attributes to category') }}</h3>
                                <div class="card-toolbar">
                                    <button type="button" data-repeater-create="" class="btn btn-sm btn-light-primary">
                                        <i class="fas fa-plus-circle"></i> {{ __('Add another variation') }}
                                    </button>

                                    <button type="submit" class="btn btn-sm btn-light-success" style="margin-left: 10px;">
                                        <i class="fas fa-plus-circle"></i> {{ __('Save changes') }}
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div data-repeater-list="kt_ecommerce_add_product_options" class="row">
                                        @if($element->attrs()->count())
                                            @foreach($element->attrs()->orderByPivot('sort')->get() as $attribute)
                                                <div data-repeater-item="" class="form-group align-items-center gap-5 col-md-3 mt-3">
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <button type="button" data-repeater-delete="" class="btn btn-sm btn-icon btn-light-danger">
                                                                <i class="fas fa-trash fs-2"></i>
                                                            </button>

                                                            <div class="w-100 w-md-200px d-inline-block">
                                                                <select class="form-select select3" name="product_option" data-placeholder="{{ __('Select a variation') }}" data-kt-ecommerce-catalog-add-product="product_option">
                                                                    <option value="">-</option>
                                                                    @foreach($attributes as $group => $options)
                                                                        <optgroup label="{{ $group }}">
                                                                            @foreach($options as $option)
                                                                                <option {{ $option->id == $attribute->id ? 'selected' : '' }} value="{{ $option->id }}">{{ $option->title }}</option>
                                                                            @endforeach
                                                                        </optgroup>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <div data-repeater-item="" class="form-group align-items-center gap-5 col-md-3 mt-3">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <button type="button" data-repeater-delete="" class="btn btn-sm btn-icon btn-light-danger">
                                                            <i class="fas fa-trash fs-2"></i>
                                                        </button>

                                                        <div class="w-100 w-md-200px d-inline-block">
                                                            <select class="form-select select3" name="product_option" data-placeholder="{{ __('Select a variation') }}" data-kt-ecommerce-catalog-add-product="product_option">
                                                                <option value="">-</option>
                                                                @foreach($attributes as $group => $options)
                                                                    <optgroup label="{{ $group }}">
                                                                        @foreach($options as $option)
                                                                            <option value="{{ $option->id }}">{{ $option->title }}</option>
                                                                        @endforeach
                                                                    </optgroup>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


@endsection
@section('section-js')
    <script src="{{ theme()->publicPath('plugins/custom/formrepeater/formrepeater.bundle.js?v1') }}"></script>

    <script>
        $(document).ready(function() {

            $('#kt_ecommerce_add_product_options').repeater({
                initEmpty: false,

                defaultValues: {
                    'text-input': 'foo'
                },

                show: function () {
                    $(this).slideDown();
                    $(this).find(".select3").select2({"placeholder": "-", allowClear: true});
                },

                hide: function (deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });

            $(".select3").select2({"placeholder": "-", allowClear: true});
        });
    </script>
@endsection
