@extends(theme()->layout())
@section('content')
    <div class="row">
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs nav-pills flex-row border-0 flex-md-column me-5 mb-3 mb-md-0 fs-6 min-w-lg-200px">
                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributes()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributes()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Attributes') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesSettings()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesSettings()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Settings') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesOrder()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesOrder()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Order') }}</span>
                                </span>
                            </a>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-md-10 remove-mt">
            {!! $form->renderForm() !!}
        </div>
    </div>


@endsection
@section('section-js')
    <script src="{{ theme()->publicPath('plugins/custom/formrepeater/formrepeater.bundle.js?v1') }}"></script>

    <script>
        $(document).ready(function() {

            $('#kt_ecommerce_add_product_options').repeater({
                initEmpty: false,

                defaultValues: {
                    'text-input': 'foo'
                },

                show: function () {
                    $(this).slideDown();
                    $(this).find(".select3").select2({"placeholder": "-", allowClear: true});
                },

                hide: function (deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });

            $(".select3").select2({"placeholder": "-", allowClear: true});
        });
    </script>
@endsection
