@extends(theme()->layout())
@section('content')
    <div class="row">
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-tabs nav-pills flex-row border-0 flex-md-column me-5 mb-3 mb-md-0 fs-6 min-w-lg-200px">
                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributes()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributes()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Attributes') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesSettings()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesSettings()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Settings') }}</span>
                                </span>
                            </a>
                        </li>

                        <li class="nav-item w-75 me-0 mb-md-2">
                            <a class="nav-link w-100 py-1 px-2 {{ (Route::currentRouteName() == $element->routeAttributesOrder()->getRouteName() ? 'active' : '') }}" href="{{ $element->routeAttributesOrder()->getRoutePath() }}">
                                <span class="d-flex flex-column align-items-start">
                                    <span class="fw-semibold">{{ __('Order') }}</span>
                                </span>
                            </a>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-md-10 remove-mt">
            <form action="{{ $element->routeAttributesOrder()->getRoutePath() }}" method="post" class="attributes-order">
                @csrf
                <div data-kt-ecommerce-catalog-add-product="auto-options">
                    <div id="kt_ecommerce_add_product_options">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{ __('Change attributes order') }}</h3>
                                <div class="card-toolbar">
                                    <button type="submit" class="btn btn-sm btn-light-success" style="margin-left: 10px;">
                                        <i class="fas fa-plus-circle"></i> {{ __('Save changes') }}
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="dd">
                                        <ol class="dd-list">
                                            @if($element->attrs->count())
                                                @foreach($element->attrs()->orderByPivot('sort')->get() as $attribute)
                                                    <li class="dd-item" data-id="{{ $attribute->id }}">
                                                        <div class="dd-handle">
                                                            <div style="float: left;">
                                                                {{ $attribute->title }}
                                                            </div>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            @endif
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


@endsection
@section('section-js')
<script>
    $(document).ready(function() {
        $('.dd').nestable({
            maxDepth: 1,
            callback: function (l, e) {
                console.log(JSON.stringify($('.dd').nestable('serialize')));
            },
        });

        $('.attributes-order').submit(function (e) {
            e.stopPropagation();
            e.preventDefault();
            let resp;
            let form = $(this);
            $.ajax({
                async: false, type: "POST", cache: false, url: form.attr("action"),
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {"list": JSON.stringify($('.dd').nestable('serialize'))},
                success: function (response) {
                    resp = response;
                },
                error: function (response) {

                }
            });

            location.reload();
            return false;
        });
    });
</script>
@endsection
