<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attribute_product_category', function (Blueprint $table) {
            $table->id();
            $table->foreignId('attribute_id')->constrained()->cascadeOnDelete();
            $table->foreignId('product_category_id')->constrained()->cascadeOnDelete();

            $table->integer('sort')->index()->default(999);
            $table->boolean('is_visible_in_product')->default(true)->index();
            $table->boolean('is_visible_in_category')->default(true)->index();
            $table->boolean('is_filterable_lg')->default(true)->index();
            $table->boolean('is_filterable_sm')->default(true)->index();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
