<?php

namespace ViartasShop\Cart\Providers;

use ViartasCore\Core\Providers\BasePackageServiceProvider;
use ViartasShop\Cart\Commands\ImportCargosPaymentsCommand;
use ViartasShop\Cart\Commands\ImportCountriesCommand;
use ViartasShop\Cart\Middleware\EnsureCartCookie;
use ViartasShop\Cart\ViartasCart as ViartasShop;

class PackageServiceProvider extends BasePackageServiceProvider
{
    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {

    }

    /**
     * @return void
     */
    public function register(): void
    {
        $this->app->singleton(ViartasShop::class, function ($app) {
            return new ViartasShop();
        });

        parent::register();
    }

    /**
     * @return void
     */
    public function boot(): void
    {
        $router = $this->app['router'];

        $router->pushMiddlewareToGroup(
            'ensureCartCookie', EnsureCartCookie::class
        );

        parent::boot();
    }

    /**
     * @return string[]
     */
    public function artisanCommands(): array
    {
        return [
            ImportCountriesCommand::class,
            ImportCargosPaymentsCommand::class,
        ];
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [
            'web.*.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-shop/cart',
                    'file' => 'resources/js/cart.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
            ],
        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'accounting.products.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
        ];
    }
}
