<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use ViartasCore\Core\Models\BaseModel;

class Warehouse extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'user_id',
        'title',
        'content',
        'country_id',
        'state',
        'city',
        'address',
        'zip',
        'is_own',
    ];

    /**
     * @return BelongsTo
     */
    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }
}
