<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use ViartasCore\Core\Models\BaseModel;

class Payment extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'driver',
        'type',
        'tag',
        'title',
        'price',
        'threshold',
        'is_active',
    ];

    /**
     * @return BelongsToMany
     */
    public function cargos(): BelongsToMany
    {
        return $this->belongsToMany(Cargo::class, 'cargo_payment')
            ->using(CargoPayment::class)
            ->withPivot(['country_id', 'is_active'])
            ->withTimestamps();
    }
}
