<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use ViartasCore\Core\Models\BaseModel;

class Customer extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'user_id',
        'is_company',
        'first_name',
        'last_name',
        'phone',
        'code',
        'vat',
        'country_id',
        'state',
        'city',
        'address',
        'zip',
        'is_company',
        'title',
    ];

    /**
     * @var string[]
     */
    public array $translatable = [];

    /**
     * @return BelongsTo
     */
    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }
}
