<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use ViartasCore\Core\Models\BaseModel;

class Country extends BaseModel
{
    use HasFactory;

    /**
     * @var string[]
     */
    protected $fillable = [
        'iso2','iso3','iso_numeric','title',
        'emoji_flag','calling_codes','idd',
        'vat','vat_effective_date','vat_source_url'
    ];

    /**
     * @var string[]
     */
    protected $casts = [
        'calling_codes' => 'array',
        'idd'           => 'array',
        'vat'           => 'array',
        'vat_effective_date' => 'date',
    ];

    /**
     * @return BelongsToMany
     */
    public function cargos(): BelongsToMany
    {
        return $this->belongsToMany(Cargo::class, 'cargo_country')
            ->using(CargoCountry::class)
            ->withPivot(['price', 'threshold'])
            ->withTimestamps();
    }
}
