<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use ViartasCore\Core\Models\BaseModel;
use ViartasShop\Attributes\Models\Accounting\AttributeValue;
use ViartasSupport\Number\Number;

class CartProductAttribute extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'cart_product_id',
        'attribute_value_id',
        'quantity',
        'price',
        'comment',
    ];

    /**
     * @var \class-string[]
     */
    protected $casts = [
        'price' => Number::class,
        'quantity' => Number::class,
    ];

    /**
     * @return BelongsTo
     */
    public function cartProduct(): BelongsTo
    {
        return $this->belongsTo(CartProduct::class);
    }

    /**
     * @return BelongsTo
     */
    public function attributeValue(): BelongsTo
    {
        return $this->belongsTo(AttributeValue::class);
    }
}
