<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use ViartasCore\Core\Models\BaseModel;
use ViartasShop\Products\Models\Accounting\Product;
use ViartasSupport\Number\Number;

class CartProduct extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'cart_id',
        'product_id',
        'quantity',
        'price',
        'comment',
    ];

    protected $casts = [
        'price' => Number::class,
        'quantity' => Number::class,
    ];

    /**
     * @return BelongsTo
     */
    public function cart(): BelongsTo
    {
        return $this->belongsTo(Cart::class);
    }

    /**
     * @return BelongsTo
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * @return HasMany
     */
    public function cartProductAttributes(): HasMany
    {
        return $this->hasMany(CartProductAttribute::class);
    }
}
