<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Relations\HasMany;
use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\HasMetaTags;

class Cart extends BaseModel
{
    use HasMetaTags;

    /**
     * @var string[]
     */
    protected $fillable = [
        'user_id',
        'hash',
        'status',
        'comment',
        'customer_data',
        'delivery_data',
        'payment_data',
    ];

    /**
     * @var string
     */
    protected string $module = 'cart';

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @var string
     */
    protected string $element_title = 'Cart';

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'title'; //workaround
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        $config = [
            'edit' => $this->menuItem(__('Main settings'), $this->routeEdit()),
            'inventory' => $this->menuItem(__('Inventory'), $this->routeEdit()),
            'attributes' => $this->menuItem(__('Attributes'), $this->routeEdit()),
            'upload_documents' => $this->menuItem(__('Upload documents'), $this->routeEdit()),
            'documents' => $this->menuItem(__('Documents'), $this->routeEdit()),
            'reviews' => $this->menuItem(__('Reviews'), $this->routeEdit()),
            'activity' => $this->menuItem(__('Activity'), $this->routeEdit()),
        ];

        if ($this->usesMedia()) {
            $config['upload_images'] = $this->menuItem(__('Upload images'), $this->routeUploadImages());
            $config['images'] = $this->menuItem(__('Images'), $this->routeUploadImages());
        }

        return $config;
    }

    /**
     * @return HasMany
     */
    public function cartProducts(): HasMany
    {
        return $this->hasMany(CartProduct::class, 'cart_id', 'id');
    }
}
