<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use ViartasCore\Core\Models\BaseModel;

class CargoGroup extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'content',
        'is_active',
    ];

    /**
     * @return HasMany
     */
    public function cargos(): HasMany
    {
        return $this->hasMany(Cargo::class);
    }
}
