<?php

namespace ViartasShop\Cart\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use ViartasCore\Core\Models\BaseModel;

class Cargo extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'cargo_group_id',
        'user_id',
        'warehouse_id',
        'driver',
        'type',
        'tag',
        'title',
        'price',
        'threshold',
        'is_active',
    ];

    /**
     * @return BelongsTo
     */
    public function warehouse(): BelongsTo
    {
        return $this->belongsTo(Warehouse::class);
    }

    /**
     * @return BelongsToMany
     */
    public function countries(): BelongsToMany
    {
        return $this->belongsToMany(Country::class, 'cargo_country')
            ->using(CargoCountry::class)
            ->withPivot(['price', 'threshold'])
            ->withTimestamps();
    }

    /**
     * @return BelongsToMany
     */
    public function payments(): BelongsToMany
    {
        return $this->belongsToMany(Payment::class, 'cargo_payment')
            ->using(CargoPayment::class)
            ->withPivot(['country_id', 'is_active'])
            ->withTimestamps();
    }

    /**
     * @return BelongsTo
     */
    public function group(): belongsTo
    {
        return $this->belongsTo(CargoGroup::class);
    }
}
