<?php

namespace ViartasShop\Cart\Forms\Web;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasShop\ProductCategories\Models\Accounting\ProductCategory;

class CheckoutForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.products.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.products.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        $product_categories = ProductCategory::query()
            ->whereNull('product_category_id')
            ->with('descendants', function ($q) {
                $q->orderBy('title');
            })
            ->orderBy('title')
            ->get();

        return [
            'group2' => [
                'product_category_id' => [
                    'title' => __('Main category'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'options' => $product_categories,
                    'nested' => true,
                    'required' => true,
                    'nested_fields' => [
                        'children' => 'descendants',
                        'key' => 'id',
                        'value' => 'title',
                    ],
                    'description' => __('Add product to a category.'),
                ],
                'layout' => [
                    'title' => __('Layout'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'required' => true,
                    'options' => [
                        'default' => __('Default'),
                        'special' => __('Special'),
                    ],
                    'description' => __('Assign a template from your current theme to define how a single product is displayed.'),
                ],
                'is_visible' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'rules' => ['bool'],
                    'options' => [
                        '1' => 'Visible',
                    ],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
            'group5' => [
                'additional_categories' => [
                    'title' => __('Additional categories'),
                    'type' => Field::SELECT,
                    'size' => 12,
                    'options' => $product_categories,
                    'nested' => true,
                    'nested_fields' => [
                        'children' => 'descendants',
                        'key' => 'id',
                        'value' => 'title',
                    ],
                    'description' => __('Add product additional category.'),
                ],
            ],
            'group4' => [
                'tags' => [
                    'title' => __('Tags'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'description' => __('Add tags to a product.'),
                ],
            ],
            'group1' => [
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                    'description' => __('A product title is required and recommended to be unique.'),
                ],
                'content' => [
                    'title' => __('Content'),
                    'type' => Field::TEXTAREA,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                    'description' => __('Set a description to the product for better visibility.'),
                ],
            ],
            'group3' => [
                'price' => [
                    'title' => __('Price'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'rules' => ['numeric'],
                    'required' => true,
                    'description' => __('Set the product price.'),
                ],
            ],
            'group6' => [
                'is_physical' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'rules' => ['bool'],
                    'options' => [
                        '1' => 'This is a physical product',
                    ],
                    'description' => __('Set if the product is a physical or digital item. Physical products may require shipping.'),
                ],
                'weight' => [
                    'title' => __('Weight'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'rules' => ['numeric'],
                    'required' => true,
                    'description' => __('Set a product weight in kilograms (kg).'),
                ],
                'width' => [
                    'title' => __('Width (w)'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['numeric'],
                    'required' => true,
                    'description' => __('Enter the product dimensions in centimeters (cm)..'),
                ],
                'height' => [
                    'title' => __('Height (h)'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['numeric'],
                    'required' => true,
                ],
                'length' => [
                    'title' => __('Length (l)'),
                    'type' => Field::TEXT,
                    'size' => 4,
                    'rules' => ['numeric'],
                    'required' => true,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Product content'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid2',
            ],
            'group2' => [
                'title' => __('Product settings'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid1',
            ],
            'group5' => [
                'title' => __('Additional categories'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid1',
            ],
            'group3' => [
                'title' => __('Pricing'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid2',
            ],
            'group6' => [
                'title' => __('Shipping'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid2',
            ],
            'group4' => [
                'title' => __('Tags'),
                'layout' => Group::CARD,
                'size' => 12,
                'grid' => 'grid1',
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function gridAttributes(): array
    {
        return [
            'grid1' => [
                'size' => 3,
            ],
            'grid2' => [
                'size' => 9,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
