<?php

namespace ViartasShop\Cart\Controllers\Web;

use ViartasCore\Core\Controllers\WebController;
use Illuminate\Contracts\View\View;
use ViartasShop\Cart\Forms\Web\CheckoutForm;
use ViartasShop\Cart\Models\Accounting\Cargo;
use ViartasShop\Cart\Models\Accounting\CargoGroup;
use ViartasShop\Cart\Models\Accounting\Payment;

class CheckoutController extends WebController
{
    /**
     * @return mixed
     */
    public function index(CheckoutForm $form): View
    {
        return theme_view('web.cart.checkout', [
            'form' => $form->build(),
            'cargoGroups' => CargoGroup::query()->whereHas('cargos', function ($query) {
                $query->where('type', 'pickup');
            })->get(),
            'cargos' => Cargo::query()->where('type', 'delivery')->get(),
            'payments' => Payment::query()->get(),
        ]);
    }
}
