<?php

namespace ViartasShop\Cart\Controllers\Web;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Blade;
use ViartasCore\Core\Controllers\WebController;
use Illuminate\Contracts\View\View;
use ViartasShop\Cart\Facades\ViartasCart;
use ViartasShop\Cart\Requests\CartAddRequest;
use ViartasShop\Products\Models\Accounting\Product;

class CartController extends WebController
{
    /**
     * @return mixed
     */
    public function index(): View
    {
        return theme_view('web.cart.index');
    }

    /**
     * @param int $id
     * @param CartAddRequest $request
     * @return string
     */
    public function store(int $id, CartAddRequest $request): string
    {
        $product = Product::findOrFail($id);
        $data = $request->validated();

        ViartasCart::add($product, $data['quantity']);

        return $this->widget();
    }


    /**
     * @return string
     */
    public function widget(): string
    {
        return Blade::render('<x:cart::widget />');
    }
}
