<?php

namespace ViartasShop\Cart\Controllers\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use ViartasCore\Core\Controllers\AccountingController;
use ViartasShop\Cart\Tables\Accounting\CartTable;

class CartController extends AccountingController
{
    /**
     * @param CartTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(CartTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.cart.index', compact('table'))
        );
    }
}
