<?php

namespace ViartasShop\Cart\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use ViartasShop\Cart\Models\Accounting\Cargo;
use ViartasShop\Cart\Models\Accounting\CargoGroup;
use ViartasShop\Cart\Models\Accounting\Country;
use ViartasShop\Cart\Models\Accounting\Payment;
use ViartasShop\Cart\Models\Accounting\Warehouse;

class ImportCargosPaymentsCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'cargo:import';

    /**
     * @var array
     */
    protected array $warehouses = [];

    /**
     * @var array
     */
    protected array $cargoGroups = [];

    /**
     * @var array
     */
    protected array $cargos = [];

    /**
     * @var array
     */
    protected array $payments = [];

    /**
     * @return void
     */
    public function handle(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Payment::query()->truncate();
        Cargo::query()->truncate();
        CargoGroup::query()->truncate();
        Warehouse::query()->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $this->warehouses();
        $this->cargoGroups();
        $this->cargos();
        $this->payments();
    }

    /**
     * @return void
     */
    protected function warehouses(): void
    {
        $this->warehouses[] = [
            'user_id' => 1,
            'title' => [
                'lt' => 'Vilniuje, Laisvės pr. 60',
                'en' => 'Vilnius, Laisves ave. 60',
                'ru' => 'Вильнюс, пр. Laisvės 60',
            ],
            'content',
            'country_id' => Country::where('iso2', 'LT')->first()->id,
            'state' => 'Vilniaus miestas',
            'city' => 'Vilnius',
            'address' => 'Laisvės pr. 60',
            'zip' => '05120',
            'is_own' => true,
        ];

        $this->warehouses[] = [
            'user_id' => 1,
            'title' => [
                'lt' => 'Vilniuje, Ukmergės g. 363',
                'en' => 'Vilnius, Ukmergės str. 363',
                'ru' => 'Вильнюс, ул. Ukmergės 363',
            ],
            'content',
            'country_id' => Country::where('iso2', 'LT')->first()->id,
            'state' => 'Vilniaus miestas',
            'city' => 'Vilnius',
            'address' => 'Ukmergės g. 363',
            'zip' => '06327',
            'is_own' => true,
        ];

        $this->warehouses[] = [
            'user_id' => 1,
            'title' => [
                'lt' => 'Nederland aukcionas',
                'en' => 'Nederland auction',
                'ru' => 'Nederland аукцион',
            ],
            'content',
            'country_id' => Country::where('iso2', 'NL')->first()->id,
            'state' => 'Amsterdam',
            'city' => 'Amsterdam',
            'address' => 'Amsterdam',
            'zip' => '06327',
            'is_own' => false,
        ];

        foreach ($this->warehouses as $warehouse) {
            Warehouse::query()->create($warehouse);
        }
    }

    /**
     * @return void
     */
    protected function cargoGroups(): void
    {
        $this->cargoGroups[] = [
            'title' => [
                'lt' => 'Atsiėmimas parduotuvėje',
                'en' => 'Pickup from store',
                'ru' => 'Самовывоз из магазина'
            ],
            'is_active',
        ];

        $this->cargoGroups[] = [
            'title' => [
                'lt' => 'Pristatymas į namus',
                'en' => 'Home delivery',
                'ru' => 'Доставка на дом'
            ],
            'is_active',
        ];

        $this->cargoGroups[] = [
            'title' => [
                'lt' => 'Atsiėmimas paštomate',
                'en' => 'Pickup from parcel locker',
                'ru' => 'Получение в постамате'
            ],
            'is_active',
        ];

        foreach ($this->cargoGroups as $cargoGroup) {
            CargoGroup::query()->create($cargoGroup);
        }
    }

    /**
     * @return void
     */
    protected function cargos(): void
    {
        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 1,
            'warehouse_id' => 1,
            'type' => 'pickup',
            'tag' => 'laisves',
            'title' => [
                'lt' => 'Vilniuje, Laisvės pr. 60',
                'en' => 'Vilnius, Laisves ave. 60',
                'ru' => 'Вильнюс, пр. Laisvės 60',
            ],
            'price' => 0,
            'threshold' => 0,
            'is_active' => true,
        ];

        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 1,
            'warehouse_id' => 2,
            'type' => 'pickup',
            'tag' => 'big',
            'title' => [
                'lt' => 'Vilniuje, PC BIG, Ukmergės g. 363',
                'en' => 'Vilnius, BIG Mall, Ukmergės str. 363',
                'ru' => 'Вильнюс, ТЦ BIG, ул. Ukmergės 363',
            ],
            'price' => 0,
            'threshold' => 0,
            'is_active' => true,
        ];

        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 2,
            'type' => 'delivery',
            'tag' => 'dpd_cargo',
            'title' => [
                'lt' => 'DPD kurjeriai',
                'en' => 'DPD couriers',
                'ru' => 'Курьеры DPD',
            ],
            'price' => 10,
            'threshold' => 100,
            'is_active' => true,
        ];

        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 2,
            'type' => 'delivery',
            'tag' => 'venipak_cargo',
            'title' => [
                'lt' => 'Venipak kurjeriai',
                'en' => 'Venipak couriers',
                'ru' => 'Курьеры Venipak',
            ],
            'price' => 10,
            'threshold' => 100,
            'is_active' => true,
        ];

        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 3,
            'type' => 'delivery',
            'tag' => 'dpd_post',
            'title' => [
                'lt' => 'DPD paštomatai',
                'en' => 'DPD parcel lockers',
                'ru' => 'Почтоматы DPD',
            ],
            'price' => 10,
            'threshold' => 100,
            'is_active' => true,
        ];

        $this->cargos[] = [
            'user_id' => 1,
            'cargo_group_id' => 3,
            'type' => 'delivery',
            'tag' => 'omniva_post',
            'title' => [
                'lt' => 'Omniva paštomatai',
                'en' => 'Omniva parcel lockers',
                'ru' => 'Почтоматы Omniva',
            ],
            'price' => 10,
            'threshold' => 100,
            'is_active' => true,
        ];

        foreach ($this->cargos as $cargo) {
            $created = Cargo::query()->create($cargo);
            $created->countries()->attach(Country::where('iso2', 'LT')->first()->id, [
                'price' => ($cargo['type'] == 'pickup' ? 0.00 : 10.00),
                'threshold' => ($cargo['type'] == 'pickup' ? 0.00 : 100.00),
            ]);
        }
    }

    /**
     * @return void
     */
    protected function payments(): void
    {
        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'cash',
            'title' => [
                'en' => 'Cash on pickup',
                'lt' => 'Grynaisiais atsiimant',
                'ru' => 'Оплата при получении',
            ],
            'price' => 0,
            'threshold' => 0,
        ];

        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'card',
            'title' => [
                'en' => 'Card on pickup',
                'lt' => 'Grynaisiais atsiimant',
                'ru' => 'Картой при получении',
            ],
            'price' => 0,
            'threshold' => 0,
        ];

        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'cod',
            'title' => [
                'en' => 'Cash on delivery',
                'lt' => 'Mokėjimas pristatant',
                'ru' => 'Оплата при доставке',
            ],
            'price' => 2,
            'threshold' => 0,
        ];

        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'bank_transfer',
            'title' => [
                'lt' => 'Banko pavedimas',
                'en' => 'Bank transfer',
                'ru' => 'Банковский перевод',
            ],
            'price' => 0,
            'threshold' => 0,
        ];

        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'paysera',
            'title' => [
                'lt' => 'Internetinė bankininkystė',
                'en' => 'Internet banking',
                'ru' => 'Интернет-банкинг',
            ],
            'price' => 0,
            'threshold' => 0,
        ];

        $this->payments[] = [
            'user_id' => 1,
            'tag' => 'credit_card',
            'title' => [
                'lt' => 'Mokėjimas kortele internetu',
                'en' => 'Card online',
                'ru' => 'Оплата картой онлайн',
            ],
            'price' => 0,
            'threshold' => 0,
        ];

        foreach ($this->payments as $payment) {
            $created = Payment::query()->create($payment);

            $cargos = Cargo::query()->get();

            if ($created->id < 3) {
                $cargos = Cargo::query()->where('type', 'pickup')->get();
            }

            if ($created->id == 3) {
                $cargos = Cargo::query()->where('type', 'delivery')->get();
            }

            foreach ($cargos as $cargo) {
                $created->cargos()->attach($cargo->id, [
                    'price' => $payment['price'],
                    'threshold' => $payment['threshold'],
                    'country_id' => Country::where('iso2', 'LT')->first()->id,
                ]);
            }
        }
    }
}
