@extends(theme()->layout())
@section('content')
    <!-- Checkout section Start -->
    <section class="checkout-section-2 section-b-space">
        <div class="container-fluid-lg">
            <div class="row g-sm-4 g-3">
                <div class="col-lg-8">
                    <div class="left-sidebar-checkout">
                        <div class="checkout-detail-box">
                            <ul>
                                <li>
                                    <div class="checkout-icon">
                                        <lord-icon target=".nav-item" src="https://cdn.lordicon.com/kdduutaw.json" trigger="loop" colors="primary:#0baf9a" class="lord-icon"></lord-icon>
                                    </div>
                                    <div class="checkout-box">
                                        <div class="checkout-title">
                                            <h4>{{ __('checkout.type') }}</h4>
                                        </div>

                                        <div class="checkout-detail">
                                            <div class="row g-4">
                                                <div class="col-xxl-6 col-lg-12 col-md-6">
                                                    <div class="delivery-address-box">
                                                        <div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="jack" id="flexRadioDefault1">
                                                            </div>

                                                            <ul class="delivery-address-detail">
                                                                <li>
                                                                    <h4 class="fw-500">{{ __('checkout.not-registered_label') }}</h4>
                                                                </li>
                                                                <li>
                                                                    <p class="text-content">
                                                                        {{ __('checkout.not-registered_content') }}
                                                                    </p>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-lg-12 col-md-6">
                                                    <div class="delivery-address-box">
                                                        <div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="jack" id="flexRadioDefault1">
                                                            </div>

                                                            <ul class="delivery-address-detail">
                                                                <li>
                                                                    <h4 class="fw-500">{{ __('checkout.registered_label') }}</h4>
                                                                </li>
                                                                <li>
                                                                    <p class="text-content">
                                                                        {{ __('checkout.registered_content') }}
                                                                    </p>
                                                                </li>
                                                                <li>
                                                                    <p class="text-content">
                                                                        <a href="{{ route(\ViartasCore\Core\Facades\Viartas::driver()->app()->login()) }}" class="btn btn-sm theme-bg-color text-white">{{ __('globals.login') }}</a>
                                                                    </p>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>

                                <li>
                                    <div class="checkout-icon">
                                        <lord-icon target=".nav-item" src="https://cdn.lordicon.com/ggihhudh.json" trigger="loop-on-hover" colors="primary:#121331,secondary:#646e78,tertiary:#0baf9a" class="lord-icon"></lord-icon>
                                    </div>
                                    <div class="checkout-box">
                                        <div class="checkout-title">
                                            <h4>{{ __('globals.customer') }}</h4>
                                        </div>

                                        <div class="checkout-detail">
                                            <div class="row g-4">
                                                <div class="col-xxl-6 col-lg-12 col-md-6">
                                                    <div class="delivery-address-box">
                                                        <div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="jack" id="flexRadioDefault1">
                                                            </div>

                                                            <div class="label">
                                                                <label>{{ __('globals.customer') }}</label>
                                                            </div>

                                                            <ul class="delivery-address-detail">
                                                                <li>
                                                                    <h4 class="fw-500">Jack Jennas</h4>
                                                                </li>

                                                                <li>
                                                                    <p class="text-content"><span
                                                                            class="text-title">Address
                                                                            : </span>8424 James Lane South San
                                                                        Francisco, CA 94080</p>
                                                                </li>

                                                                <li>
                                                                    <h6 class="text-content"><span
                                                                            class="text-title">Pin Code
                                                                            :</span> +380</h6>
                                                                </li>

                                                                <li>
                                                                    <h6 class="text-content mb-0"><span
                                                                            class="text-title">Phone
                                                                            :</span> + 380 (0564) 53 - 29 - 68</h6>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-6 col-lg-12 col-md-6">
                                                    <div class="delivery-address-box">
                                                        <div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="jack"
                                                                       id="flexRadioDefault2" checked="checked">
                                                            </div>

                                                            <div class="label">
                                                                <label>{{ __('globals.company') }}</label>
                                                            </div>

                                                            <ul class="delivery-address-detail">
                                                                <li>
                                                                    <h4 class="fw-500">MB Viartas</h4>
                                                                </li>

                                                                <li>
                                                                    <p class="text-content">
                                                                        <span class="text-title">
                                                                            Address :</span>Nakhimovskiy R-N / Lastovaya Ul., bld. 5/A, appt. 12
                                                                    </p>
                                                                </li>

                                                                <li>
                                                                    <h6 class="text-content">
                                                                        <span class="text-title">Pin Code :</span>
                                                                        +380
                                                                    </h6>
                                                                </li>

                                                                <li>
                                                                    <h6 class="text-content mb-0">
                                                                        <span class="text-title">Phone:
                                                                        </span> + 380 (0564) 53 - 29 - 68
                                                                    </h6>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>

                                <li>
                                    <div class="checkout-icon">
                                        <lord-icon target=".nav-item" src="https://cdn.lordicon.com/oaflahpk.json" trigger="loop-on-hover" colors="primary:#0baf9a" class="lord-icon"></lord-icon>
                                    </div>
                                    <div class="checkout-box">
                                        <div class="checkout-title">
                                            <h4>{{ __('checkout.delivery-type') }}</h4>
                                        </div>

                                        <div class="checkout-detail">
                                            <div class="accordion accordion-flush custom-accordion" id="accordionFlushExample">

                                                @foreach($cargoGroups as $group)
                                                    <div class="accordion-item">
                                                        <div class="accordion-header" id="flush-heading-{{ $group->id }}">
                                                            <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#flush-collapse-{{ $group->id }}">
                                                                <div class="custom-form-check form-check mb-0">
                                                                    <label class="form-check-label" for="cargo-group-{{ $group->id }}">
                                                                        <input class="form-check-input mt-0" type="radio" name="cargo" id="cargo-group-{{ $group->id }}"> {{ $group->title }}
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="flush-collapse-{{ $group->id }}" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                                                            <div class="accordion-body row">
                                                                @foreach($group->cargos as $cargo)
                                                                    <div class="col-xxl-6 col-lg-12 col-md-6">
                                                                        <div class="delivery-address-box mt-1">
                                                                            <div>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input" type="radio" name="pickup" id="pickup-{{ $cargo->id }}" value="{{ $cargo->id }}">
                                                                                </div>

                                                                                <ul class="delivery-address-detail">
                                                                                    <li>
                                                                                        <ul class="delivery-address-detail">
                                                                                            <li>
                                                                                                <h4 class="fw-500">{{ $cargo->title }}</h4>
                                                                                            </li>

                                                                                            <li>
                                                                                                <p class="text-content">
                                                                                                    <span class="text-title">Address :</span>
                                                                                                    {{ $cargo->warehouse->address }}
                                                                                                </p>
                                                                                            </li>

                                                                                            <li>
                                                                                                <h6 class="text-content mb-0">
                                                                                                    <span class="text-title">Phone:</span>
                                                                                                    + 380 (0564) 53 - 29 - 68
                                                                                                </h6>
                                                                                            </li>
                                                                                        </ul>
                                                                                    </li>
                                                                                </ul>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach

                                                @foreach($cargos as $cargo)
                                                    <div class="accordion-item">
                                                        <div class="accordion-header" id="flush-heading-{{ $cargo->id }}">
                                                            <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#flush-collapse-{{ $cargo->id }}">
                                                                <div class="custom-form-check form-check mb-0">
                                                                    <label class="form-check-label" for="{{ $cargo->tag }}">
                                                                        <input class="form-check-input mt-0" type="radio" name="cargo" id="{{ $cargo->tag }}"> {{ $cargo->title }}
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div id="flush-collapse-{{ $cargo->id }}" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                                                            <div class="accordion-body row">
                                                                @for($i=1;$i<3;$i++)
                                                                    <div class="col-xxl-6 col-lg-12 col-md-6">
                                                                        <div class="delivery-address-box mt-1">
                                                                            <div>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input" type="radio" name="jack" id="flexRadioDefault1">
                                                                                </div>

                                                                                <ul class="delivery-address-detail">
                                                                                    <li>
                                                                                        <ul class="delivery-address-detail">
                                                                                            <li>
                                                                                                <h4 class="fw-500">MB Viartas</h4>
                                                                                            </li>

                                                                                            <li>
                                                                                                <p class="text-content">
                                                                            <span class="text-title">
                                                                                Address :</span>Nakhimovskiy R-N / Lastovaya Ul., bld. 5/A, appt. 12
                                                                                                </p>
                                                                                            </li>

                                                                                            <li>
                                                                                                <h6 class="text-content">
                                                                                                    <span class="text-title">Pin Code :</span>
                                                                                                    +380
                                                                                                </h6>
                                                                                            </li>

                                                                                            <li>
                                                                                                <h6 class="text-content mb-0">
                                                                            <span class="text-title">Phone:
                                                                            </span> + 380 (0564) 53 - 29 - 68
                                                                                                </h6>
                                                                                            </li>
                                                                                        </ul>
                                                                                    </li>
                                                                                </ul>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endfor
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </li>

                                <li>
                                    <div class="checkout-icon">
                                        <lord-icon target=".nav-item" src="https://cdn.lordicon.com/qmcsqnle.json" trigger="loop-on-hover" colors="primary:#0baf9a,secondary:#0baf9a" class="lord-icon"></lord-icon>
                                    </div>
                                    <div class="checkout-box">
                                        <div class="checkout-title">
                                            <h4>Payment Option</h4>
                                        </div>

                                        <div class="checkout-detail">
                                            <x:cart::payments :cargo="$cargo ?? null" />
                                        </div>
                                    </div>
                                </li>

                                <li>
                                    <div class="checkout-icon">
                                        <lord-icon target=".nav-item" src="https://cdn.lordicon.com/exymduqj.json" trigger="loop" colors="primary:#0baf9a" class="lord-icon"></lord-icon>
                                    </div>
                                    <div class="checkout-box">
                                        <div class="checkout-title">
                                            <h4>{{ __('globals.special_notice') }}</h4>
                                        </div>

                                        <div class="checkout-detail">
                                            <div class="row">
                                                <div class="col-xxl-12">
                                                    <div class="delivery-option">
                                                        <div class="form-floating mb-lg-3 mb-2 theme-form-floating">
                                                            <textarea name="comment" class="form-control" style="height: 150px"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="right-side-summery-box">
                        <div class="summery-box-2">
                            <div class="summery-header">
                                <h3>Order Summery</h3>
                            </div>

                            <ul class="summery-contain">
                                <li>
                                    <img src="../assets/images/vegetable/product/1.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Bell pepper <span>X 1</span></h4>
                                    <h4 class="price">$32.34</h4>
                                </li>

                                <li>
                                    <img src="../assets/images/vegetable/product/2.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Eggplant <span>X 3</span></h4>
                                    <h4 class="price">$12.23</h4>
                                </li>

                                <li>
                                    <img src="../assets/images/vegetable/product/3.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Onion <span>X 2</span></h4>
                                    <h4 class="price">$18.27</h4>
                                </li>

                                <li>
                                    <img src="../assets/images/vegetable/product/4.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Potato <span>X 1</span></h4>
                                    <h4 class="price">$26.90</h4>
                                </li>

                                <li>
                                    <img src="../assets/images/vegetable/product/5.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Baby Chili <span>X 1</span></h4>
                                    <h4 class="price">$19.28</h4>
                                </li>

                                <li>
                                    <img src="../assets/images/vegetable/product/6.png"
                                         class="img-fluid blur-up lazyloaded checkout-image" alt="">
                                    <h4>Broccoli <span>X 2</span></h4>
                                    <h4 class="price">$29.69</h4>
                                </li>
                            </ul>

                            <ul class="summery-total">
                                <li>
                                    <h4>Subtotal</h4>
                                    <h4 class="price">$111.81</h4>
                                </li>

                                <li>
                                    <h4>Shipping</h4>
                                    <h4 class="price">$8.90</h4>
                                </li>

                                <li>
                                    <h4>Tax</h4>
                                    <h4 class="price">$29.498</h4>
                                </li>

                                <li>
                                    <h4>Coupon/Code</h4>
                                    <h4 class="price">$-23.10</h4>
                                </li>

                                <li class="list-total">
                                    <h4>Total (USD)</h4>
                                    <h4 class="price">$19.28</h4>
                                </li>
                            </ul>
                        </div>

                        <div class="checkout-offer">
                            <div class="offer-title">
                                <div class="offer-icon">
                                    <img src="../assets/images/inner-page/offer.svg" class="img-fluid" alt="">
                                </div>
                                <div class="offer-name">
                                    <h6>Available Offers</h6>
                                </div>
                            </div>

                            <ul class="offer-detail">
                                <li>
                                    <p>Combo: BB Royal Almond/Badam Californian, Extra Bold 100 gm...</p>
                                </li>
                                <li>
                                    <p>combo: Royal Cashew Californian, Extra Bold 100 gm + BB Royal Honey 500 gm</p>
                                </li>
                            </ul>
                        </div>

                        <button class="btn theme-bg-color text-white btn-md w-100 mt-4 fw-bold">Place Order</button>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Checkout section End -->
@endsection
@section('section-js')
    <script src="{{ theme()->publicPath('js/lusqsztk.js') }}"></script>
@endsection
