<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();

            // ISO 3166-1
            $table->char('iso2', 2)->unique()->index();       // alpha-2
            $table->char('iso3', 3)->unique()->index();       // alpha-3
            $table->smallInteger('iso_numeric')->nullable()->index(); // numeric

            // Localized names (CLDR via symfony/intl) — JSONB map: {"en":"Lithuania","lt":"Lietuva",...}
            $table->jsonb('title');

            // Phone / flags
            $table->string('emoji_flag', 16)->nullable(); // e.g., "🇱🇹"
            $table->jsonb('calling_codes')->nullable();   // e.g., ["+370"]
            $table->jsonb('idd')->nullable();             // {"root":"+3","suffixes":["70"]}

            // VAT (your own dataset, optional)
            // Example payload: {"standard_rate":21,"reduced_rates":{"9":["books"]}}
            $table->jsonb('vat')->nullable();
            $table->date('vat_effective_date')->nullable()->index();
            $table->text('vat_source_url')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

    }
};
