<div class="onhover-dropdown header-badge cart-widget">
    <button type="button" class="btn p-0 position-relative header-wishlist">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-cart"><circle cx="9" cy="21" r="1"></circle><circle cx="20" cy="21" r="1"></circle><path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path></svg>
        <span class="position-absolute top-0 start-100 translate-middle badge">
            {{ vcart()->totalQuantity() }}
            <span class="visually-hidden">unread messages</span>
        </span>
    </button>

    <div class="onhover-div">
        @if(vcart()->isEmpty())
            <ul class="cart-list">
                <li class="product-box-contain">
                    <div class="drop-cart">
                        <div class="drop-contain">
                            <h5>{{ __('cart.empty') }}</h5>
                        </div>
                    </div>
                </li>
            </ul>
        @else
            <ul class="cart-list">
                @foreach(vcart()->products() as $item)
                    <li class="product-box-contain">
                        <div class="drop-cart">
                            <a href="{{ $item->product->generateRoute() }}" class="drop-image">
                                <img src="{{ $item->product->getFirstMedia('products')->getUrl('category_preview') }}" class="blur-up lazyload" alt="">
                            </a>

                            <div class="drop-contain">
                                <a href="{{ $item->product->generateRoute() }}">
                                    <h5>{{ $item->product->title }}</h5>
                                </a>
                                <h6><span>{{ $item->quantity }} x</span> {{ $item->price->formatAsPrice() }}</h6>
                                <button class="close-button close_button">
                                    <i class="fa-solid fa-xmark"></i>
                                </button>
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>

            <div class="price-box">
                <h5>{{ __('cart.total') }}:</h5>
                <h4 class="theme-color fw-bold">{{ vcart()->totalPrice() }}</h4>
            </div>

            <div class="button-group">
                <a href="{{ route('web.cart.index') }}" class="btn btn-sm cart-button">{{ __('cart.view') }}</a>
                <a href="{{ route('web.checkout.index') }}" class="btn btn-sm cart-button theme-bg-color text-white">{{ __('checkout.label') }}</a>
            </div>
        @endif
    </div>
</div>
