<?php

namespace ViartasShop\Brands\Tables\Accounting;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use Illuminate\Http\Request;
use ViartasShop\Brands\Models\Accounting\Brand;

class MenuBrandsTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new Brand(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldTitle(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
                ->field('is_visible')
                ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add($this->addOneItemButton())
                ->add($this->addManyItemsButton())
                ->add((new DataTablesButton())->editButton()->setColor('warning'))
        ]);
    }

    public function addOneItemButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add one item'))
            ->setIcon('fa-plus-circle')
            ->setClass('add-one-menu-item')

            ->getRoute();
    }

    public function addManyItemsButton (): DataTablesButton
    {
        return (new DataTablesButton())
            ->setColor('primary')
            ->setTitle(__('Add many items button'))
            ->setIcon('fa-layer-group')
            ->setClass('add-one-menu-item-with-children')
            ->getRoute();
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.menus.items.brands'));
        $this->setFilters(route('accounting.menus.items.brands'));
        $this->setId('brands-table');
        $this->setType('simple');
        $this->setClass('brands-table');
        $this->setTitle(__('Brands'));
        $this->setIndexColumn('id');

        return $this;
    }
}
