<?php

namespace ViartasShop\Brands\Tables\Accounting;

use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use Illuminate\Http\Request;
use ViartasShop\Brands\Models\Accounting\Brand;

class BrandsTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new Brand(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldTitle(),
            $this->fieldUser(),
            $this->fieldCreatedAt(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
            ->field('is_visible')
            ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.brands.index'));
        $this->setFilters(route('accounting.brands.index'));
        $this->setId('brands-table');
        $this->setClass('brands-table');
        $this->setTitle(__('Brands'));
        $this->setIndexColumn('id');

        return $this;
    }
}
