<?php

namespace ViartasShop\Brands\Providers;

use ViartasCore\Core\Providers\BasePackageServiceProvider;
use ViartasCore\Core\Traits\HasRoutes;
use ViartasShop\Brands\Drivers\Accounting\RouteGuesser;

class PackageServiceProvider extends BasePackageServiceProvider
{
    use HasRoutes;

    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @return RouteGuesser
     */
    public function routeGuesserClass(): RouteGuesser
    {
        return new RouteGuesser();
    }

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {
        $schedule->command('example3:command')->everyMinute();
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [
            'accounting.brands.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.brands.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.brands.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.models.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.models.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.models.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'accounting.brands.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
            'accounting.models.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
        ];
    }
}
