<?php

namespace ViartasShop\Brands\Drivers\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use ViartasCore\Core\Contracts\RouteGuesserContract;
use ViartasCore\Core\Facades\Viartas;
use ViartasShop\Brands\Models\Accounting\Brand;

class RouteGuesser implements RouteGuesserContract
{
    /**
     * @var int
     */
    protected int $priority = 50;

    /**
     * @param Request $request
     * @return \Illuminate\Foundation\Application|View|Factory|Application|int|Model
     */
    public function guessRoute(Request $request): \Illuminate\Foundation\Application|View|Factory|Application|int|Model
    {
        $slugLastSegment = Viartas::driver()->app()->getSlugLastSegment();
        $slug = Viartas::driver()->app()->getSlug();

        $brand = Brand::FindBySlug($slugLastSegment);

        if (!$brand) {
            return 404;
        }

        $brandSlug = $this->generateRoute($brand);

        if ($brandSlug !== $slug) {
            return 404;
        }

        return $brand->view();
    }

    /**
     * @param Model $model
     * @return string
     */
    public function generateRoute(Model $model): string
    {
        return $model->generateRoute();
    }

    /**
     * @return int
     */
    public function priority(): int
    {
        return $this->priority;
    }
}
