<?php

use ViartasShop\Brands\Controllers\Accounting\BrandsController;
use ViartasShop\Brands\Controllers\Accounting\ModelsController;

Route::prefix('brands')->group(function () {
    Route::get('/', [BrandsController::class, 'index'])->name('brands.index');
    Route::get('/create', [BrandsController::class, 'create'])->name('brands.create');
    Route::post('/create', [BrandsController::class, 'store'])->name('brands.create');
    Route::get('/{id}/edit', [BrandsController::class, 'edit'])->name('brands.edit');
    Route::post('/{id}/edit', [BrandsController::class, 'update'])->name('brands.edit');
    Route::patch('/{id}/edit', [BrandsController::class, 'updateOneField'])->name('brands.edit');
    Route::post('/{id}/destroy', [BrandsController::class, 'destroy'])->name('brands.destroy');
    Route::get('/{id}/upload/images', [BrandsController::class, 'uploadImages'])->name('brands.upload.images');
});

Route::prefix('models')->group(function () {
    Route::get('/', [ModelsController::class, 'index'])->name('models.index');
    Route::get('/create', [ModelsController::class, 'create'])->name('models.create');
    Route::post('/create', [ModelsController::class, 'store'])->name('models.create');
    Route::get('/{id}/edit', [ModelsController::class, 'edit'])->name('models.edit');
    Route::post('/{id}/edit', [ModelsController::class, 'update'])->name('models.edit');
    Route::patch('/{id}/edit', [ModelsController::class, 'updateOneField'])->name('models.edit');
    Route::post('/{id}/destroy', [ModelsController::class, 'destroy'])->name('models.destroy');
    Route::get('/{id}/upload/images', [ModelsController::class, 'uploadImages'])->name('models.upload.images');
});
