<?php

namespace ViartasShop\Attributes\Tables\Accounting;

use Illuminate\Database\Eloquent\Builder;
use ViartasBuilders\Tables\DataTables;
use ViartasBuilders\Tables\DataTablesButton;
use Illuminate\Http\Request;
use ViartasBuilders\Tables\DataTablesRow;
use ViartasShop\Attributes\Models\Accounting\AttributeGroup;

class AttributeGroupsTable extends DataTables
{
    public function __construct(Request $request)
    {
        parent::__construct(
            new AttributeGroup(),
            $request
        );

        $this->table();

        $this->addRows([
            $this->fieldId(),
            $this->fieldTitle(),
            $this->fieldTag(),
            $this->fieldUser(),
            $this->fieldCreatedAt(),
            $this->fieldSwitch([
                ['label' => __('Visible'), 'value' => "1",],
                ['label' => __('Invisible'), 'value' => "0",]
            ])
            ->field('is_visible')
            ->title(__('Visibility')),
            $this->fieldCheckboxMassActions(),
            $this->button()
                ->add((new DataTablesButton())->editButton())
                ->add((new DataTablesButton())->destroyButton()),
        ]);
    }

    public function fieldTag(): DataTablesRow
    {
        $title = new DataTablesRow();

        $title->field('tag')
            ->title(__('Tag'))
            ->setSearchable()
            ->order(function (Builder $builder, string $direction) {
                $builder->orderBy('tag', $direction);
            });

        return $title;
    }

    public function table(): self
    {
        $this->setRoute(route('accounting.attribute-groups.index'));
        $this->setFilters(route('accounting.attribute-groups.index'));
        $this->setId('attribute-groups-table');
        $this->setClass('attribute-groups-table');
        $this->setTitle(__('Attribute groups'));
        $this->setIndexColumn('id');

        return $this;
    }
}
