<?php

namespace ViartasShop\Attributes\Providers;

use ViartasCore\Core\Providers\BasePackageServiceProvider;

class PackageServiceProvider extends BasePackageServiceProvider
{
    /**
     * php artisan vendor:publish --tag=viartas-config --force
     * @var string
     */
    public string $package_directory = __DIR__;

    /**
     * @param mixed $schedule
     * @return void
     */
    public function scheduleCommands(mixed $schedule): void
    {
        $schedule->command('example3:command')->everyMinute();
    }

    /**
     * @return array
     */
    public function javascript(): array
    {
        return [
            'accounting.attribute-groups.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.attribute-groups.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.attribute-groups.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.attributes.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.attributes.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.attributes.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],

            'accounting.values.*' => [
                [
                    'vendor' => 'viartas-js/jquery',
                    'file' => 'resources/js/jquery.js',
                    'type' => 'library', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ]
            ],

            'accounting.values.edit' => [
                [
                    'vendor' => 'viartas-js/alpinejs',
                    'file' => 'resources/js/alpinejs.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'library', //module, commonjs
                ]
            ],

            'accounting.values.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/js/datatables.js',
                    'type' => 'script', //library, module, script
                    'render_as' => 'commonjs', //module, commonjs
                ],
                [
                    'vendor' => 'viartas-js/datatables-columns-filter',
                    'file' => 'resources/js/datatablesColumnsFilter.js',
                    'type' => 'module', //library, module, script
                    'render_as' => 'module', //module, commonjs
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function css(): array
    {
        return [
            'accounting.attribute-groups.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
            'accounting.attributes.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
            'accounting.values.index' => [
                [
                    'vendor' => 'viartas-js/datatables',
                    'file' => 'resources/css/datatables.css',
                    'type' => 'script', //library, module, script
                ]
            ],
        ];
    }
}
