<?php

namespace ViartasShop\Attributes\Models\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use ViartasCore\Core\Drivers\RouteDriver;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Models\BaseModel;
use ViartasCore\Core\Traits\DefinesAsCacheItem;

class AttributeValue extends BaseModel
{
    use DefinesAsCacheItem;

    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'content', 'slug',
        'user_id',
        'attribute_id',
        'tag',
        'is_visible',
    ];

    /**
     * @var string
     */
    protected string $module = 'values';

    /**
     * @var string
     */
    protected string $layout = 'default';

    /**
     * @var string
     */
    protected string $element_title = 'Values';

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'title';
    }

    /**
     * @return array
     */
    protected function menuConfig(): array
    {
        $config = [
            'edit' => $this->menuItem(__('Main settings'), $this->routeEdit()),
            'values' => $this->menuItem(__('Values'), $this->routeValues()),
            'activity' => $this->menuItem(__('Activity'), $this->routeEdit()),
        ];

        if ($this->usesMedia()) {
            $config['upload_images'] = $this->menuItem(__('Upload images'), $this->routeUploadImages());
            $config['images'] = $this->menuItem(__('Images'), $this->routeUploadImages());
        }

        return $config;
    }

    /**
     * @return RouteDriver
     */
    public function routeIndex(): RouteDriver
    {
        return $this->routeValues();
    }

    /**
     * @return RouteDriver
     */
    public function routeValues(): RouteDriver
    {
        $route = sprintf('accounting.%s.index', $this->module);

        return new RouteDriver($route, [
            'id' => request()->route('id'),
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routeCreate(): RouteDriver
    {
        $route = sprintf('accounting.%s.create', $this->module);

        return new RouteDriver($route, [
            'id' => request()->route('id'),
        ]);
    }

    /**
     * @return RouteDriver
     */
    public function routeEdit(): RouteDriver
    {
        $route = sprintf('accounting.%s.edit', $this->module);

        return new RouteDriver($route, [
            'id' => $this->attribute_id,
            'value' => $this->id,
        ]);
    }
    /**
     * @return RouteDriver
     */
    public function routeDestroy(): RouteDriver
    {
        $route = sprintf('accounting.%s.destroy', $this->module);

        return new RouteDriver($route, [
            'id' => request()->route('id'),
            'value' => $this->id ?? 0,
        ], 'POST');
    }

    /**
     * @return RouteDriver
     */
    public function routeDestroySelected(): RouteDriver
    {
        $route = sprintf('accounting.%s.destroy', $this->module);

        return new RouteDriver($route, [
            'id' => request()->route('id'),
            'value' => 0,
        ], 'POST');
    }

    /**
     * @return BelongsTo
     */
    public function attr(): BelongsTo
    {
        return $this->belongsTo(Attribute::class, 'attribute_id', 'id');
    }

    /**
     * @return \Illuminate\Foundation\Application|View|Factory|Application
     */
    public function view(): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $app = Viartas::driver()->app()->current()->tag;
        $element = $this;
        return theme_view($app.'.'.$this->module.'.'.$this->layout, compact('element'));
    }
}
