<?php

namespace ViartasShop\Attributes\Models\Accounting;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Database\Eloquent\Relations\HasMany;
use ViartasCore\Core\Facades\Viartas;
use ViartasCore\Core\Models\BaseModel;

class AttributeGroup extends BaseModel
{
    /**
     * @var string[]
     */
    protected $fillable = [
        'title', 'tag',
        'user_id',
        'is_visible',
    ];

    /**
     * @var string
     */
    protected string $module = 'attribute-groups';

    /**
     * @var string
     */
    protected string $layout = 'default';

    /**
     * @var string
     */
    protected string $element_title = 'Attribute group';

    /**
     * @var bool
     */
    protected bool $usesRecursiveRelations = false;

    /**
     * @return string
     */
    public function getParentKeyName(): string
    {
        return 'title';
    }

    /**
     * @return HasMany
     */
    public function attributes(): HasMany
    {
        return $this->hasMany(Attribute::class, 'attribute_group_id', 'id');
    }

    /**
     * @return \Illuminate\Foundation\Application|View|Factory|Application
     */
    public function view(): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $app = Viartas::driver()->app()->current()->tag;
        $element = $this;
        return theme_view($app.'.'.$this->module.'.'.$this->layout, compact('element'));
    }
}
