<?php

namespace ViartasShop\Attributes\Forms\Accounting;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasShop\Attributes\Models\Accounting\AttributeValue;

class ValuesEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    '_method' => 'POST',
                    'route' => 'accounting.values.create',
                    'routeAttributes' => [
                        'id' => request()->route('id')
                    ],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.values.edit',
                    'routeAttributes' => [
                        'value' => 'id',
                        'id' => request()->route('id'),
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
                'content' => [
                    'title' => __('Content'),
                    'type' => Field::TEXTAREA,
                    'size' => 12,
                    'translatable' => true,
                ],
            ],
            'group2' => [
                'tag' => [
                    'title' => __('Tag'),
                    'type' => Field::TEXT,
                    'required' => true,
                    'size' => 12,
                    'rules' => ['unique:attribute_values,tag,id'],
                    'model' => AttributeValue::class,
                    'primary_key' => 'id',
                    'primary_value' => request()->value ?? false,
                ],
                'is_visible' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'rules' => ['bool'],
                    'options' => [
                        '1' => __('Visible'),
                    ],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Value content'),
                'layout' => Group::CARD,
                'size' => 8,
            ],
            'group2' => [
                'title' => __('Value settings'),
                'layout' => Group::CARD,
                'size' => 4,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
