<?php

namespace ViartasShop\Attributes\Forms\Accounting;

use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Form;
use ViartasBuilders\Forms\Group;
use ViartasShop\ProductCategories\Models\Accounting\ProductCategory;

class AttributeGroupsEditForm extends Form
{
    /**
     * @return array
     */
    protected function formOptions(): array
    {
        return [
            '_method' => 'POST',
            'id' => 'form1',
            'class' => 'form',
            'action' => 'create',
            'routes' => [
                'create' => [
                    'route' => 'accounting.attribute-groups.create',
                    'routeAttributes' => [],
                ],
                'update' => [
                    '_method' => 'POST',
                    'route' => 'accounting.attribute-groups.edit',
                    'routeAttributes' => [
                        'id' => 'id',
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function fields(): array
    {
        return [
            'group1' => [
                'title' => [
                    'title' => __('Title'),
                    'type' => Field::TEXT,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
                'content' => [
                    'title' => __('Content'),
                    'type' => Field::TEXTAREA,
                    'size' => 12,
                    'translatable' => true,
                    'required' => true,
                ],
            ],
            'group2' => [
                'is_visible' => [
                    'title' => '',
                    'type' => Field::CHECKBOX,
                    'size' => 12,
                    'rules' => ['bool'],
                    'options' => [
                        '1' => __('Visible'),
                    ],
                ],
                'save' => [
                    'title' => __('Save'),
                    'size' => '12',
                    'position' => 'text-end',
                    'class' => 'btn btn-success',
                    'type' => Field::BUTTON_SUBMIT,
                ],
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function groupAttributes(): array
    {
        return [
            'group1' => [
                'title' => __('Attribute group content'),
                'layout' => Group::CARD,
                'size' => 8,
            ],
            'group2' => [
                'title' => __('Attribute group settings'),
                'layout' => Group::CARD,
                'size' => 4,
            ],
        ];
    }

    /**
     * @return array[]
     */
    protected function validationMessages(): array
    {
        return [
            'first_name' => [],
        ];
    }
}
