<?php

namespace ViartasShop\Attributes\Controllers\Accounting;

use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use ViartasCore\Core\Controllers\AccountingController;
use ViartasShop\Attributes\Forms\Accounting\AttributesEditForm;
use ViartasShop\Attributes\Models\Accounting\Attribute;
use ViartasShop\Attributes\Tables\Accounting\AttributesTable;
use ViartasShop\Attributes\Tables\Accounting\ValuesTable;

class AttributesController extends AccountingController
{
    /**
     * @param AttributesTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(AttributesTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.attributes.index', compact('table'))
        );
    }

    /**
     * @param AttributesEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function create(AttributesEditForm $form): Application|Factory|View|\Illuminate\Foundation\Application
    {
        return theme_view('accounting.attributes.edit', [
            'form' => $form->build(),
            'element' => new Attribute(),
        ]);
    }

    /**
     * @param AttributesEditForm $form
     * @return RedirectResponse
     */
    public function store(AttributesEditForm $form): RedirectResponse
    {
        $page = Attribute::create($form->all());

        return theme_redirect()->route('accounting.attributes.edit', [
            'id' => $page->id,
        ])->with('success', __('attribute.created'));
    }

    /**
     * @param string $id
     * @param AttributesEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, AttributesEditForm $form): Application|Factory|View|\Illuminate\Foundation\Application
    {
        $product_category = Attribute::findOrFail($id);
        $form = $form->setAction('update')->build($product_category);

        return theme_view('accounting.attributes.edit', [
            'form' => $form,
            'element' => $product_category,
        ]);
    }

    /**
     * @param string $id
     * @param AttributesEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, AttributesEditForm $form): RedirectResponse
    {
        Attribute::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.attributes.edit', [
            'id' => $id,
        ])->with('success', __('attribute.updated'));
    }
    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        Attribute::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            Attribute::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.attributes.index')
                ->with('success', __('attribute.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            Attribute::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }

    public function uploadImages($id, ImagesUploadForm $images)
    {
        $page = Attribute::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(Attribute::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.attributes.common', [
            'form' => $images,
            'element' => $page,
        ]);
    }

}
