<?php

namespace ViartasShop\Attributes\Controllers\Accounting;

use ViartasCore\Core\Forms\Common\ImagesUploadForm;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use ViartasCore\Core\Controllers\AccountingController;
use ViartasShop\Attributes\Forms\Accounting\AttributeGroupsEditForm;
use ViartasShop\Attributes\Models\Accounting\AttributeGroup;
use ViartasShop\Attributes\Tables\Accounting\AttributeGroupsTable;

class AttributeGroupsController extends AccountingController
{
    /**
     * @param AttributeGroupsTable $table
     * @param Request $request
     * @return string|array|View|\Illuminate\Foundation\Application|Factory|Application
     */
    public function index(AttributeGroupsTable $table, Request $request): string|array|View|\Illuminate\Foundation\Application|Factory|Application
    {
        return $this->tableBuilder(
            $table, $request, theme_view('accounting.attribute-groups.index', compact('table'))
        );
    }

    /**
     * @param AttributeGroupsEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function create(AttributeGroupsEditForm $form): Application|Factory|View|\Illuminate\Foundation\Application
    {
        return theme_view('accounting.attribute-groups.edit', [
            'form' => $form->build(),
            'element' => new AttributeGroup(),
        ]);
    }

    /**
     * @param AttributeGroupsEditForm $form
     * @return RedirectResponse
     */
    public function store(AttributeGroupsEditForm $form): RedirectResponse
    {
        $page = AttributeGroup::create($form->all());

        return theme_redirect()->route('accounting.attribute-groups.edit', [
            'id' => $page->id,
        ])->with('success', __('attribute-group.created'));
    }

    /**
     * @param string $id
     * @param AttributeGroupsEditForm $form
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function edit(string $id, AttributeGroupsEditForm $form): Application|Factory|View|\Illuminate\Foundation\Application
    {
        $product_category = AttributeGroup::findOrFail($id);
        $form = $form->setAction('update')->build($product_category);

        return theme_view('accounting.attribute-groups.edit', [
            'form' => $form,
            'element' => $product_category,
        ]);
    }

    /**
     * @param string $id
     * @param AttributeGroupsEditForm $form
     * @return RedirectResponse
     */
    public function update(string $id, AttributeGroupsEditForm $form): RedirectResponse
    {
        AttributeGroup::findOrFail($id)->update($form->all());

        return theme_redirect()->route('accounting.attribute-groups.edit', [
            'id' => $id,
        ])->with('success', __('attribute-group.updated'));
    }
    /**
     * @param string $id
     * @param Request $request
     * @return void
     */
    public function updateOneField(string $id, Request $request): void
    {
        AttributeGroup::findOrFail($id)->update([
            $request->get('field') => $request->get('value')
        ]);
    }

    /**
     * @param string $id
     * @param Request $request
     * @return bool|RedirectResponse
     */
    public function destroy(string $id, Request $request): bool|RedirectResponse
    {
        if ($id !== '0') {
            AttributeGroup::findOrFail($id)->delete();

            return theme_redirect()->route('accounting.attribute-groups.index')
                ->with('success', __('attribute-group.deleted'));
        }

        $this->destroySelected($request);

        return true;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function destroySelected(Request $request): void
    {
        foreach ($request->elements as $element) {
            AttributeGroup::find($element)->delete();
        }

        Session::flash('success', __('elements.selected.deleted'));
    }

    public function uploadImages($id, ImagesUploadForm $images)
    {
        $page = AttributeGroup::findOrFail($id);
        $images = $images->build();

        $images->field('images')
            ->setModel(AttributeGroup::class)
            ->setPrimaryKey('id')
            ->setPrimaryValue($id);

        return theme_view('accounting.attribute-groups.common', [
            'form' => $images,
            'element' => $page,
        ]);
    }

}
