<?php


use ViartasShop\Attributes\Controllers\Accounting\AttributeGroupsController;
use ViartasShop\Attributes\Controllers\Accounting\AttributesController;
use ViartasShop\Attributes\Controllers\Accounting\ValuesController;

Route::prefix('attributes')->group(function () {
    Route::get('/', [AttributesController::class, 'index'])->name('attributes.index');
    Route::get('/create', [AttributesController::class, 'create'])->name('attributes.create');
    Route::post('/create', [AttributesController::class, 'store'])->name('attributes.create');
    Route::get('/{id}/edit', [AttributesController::class, 'edit'])->name('attributes.edit');
    Route::post('/{id}/edit', [AttributesController::class, 'update'])->name('attributes.edit');
    Route::patch('/{id}/edit', [AttributesController::class, 'updateOneField'])->name('attributes.edit');
    Route::post('/{id}/destroy', [AttributesController::class, 'destroy'])->name('attributes.destroy');
    Route::get('/{id}/upload/images', [AttributesController::class, 'uploadImages'])->name('attributes.upload.images');

    Route::get('/{id}/values', [ValuesController::class, 'index'])->name('values.index');
    Route::get('/{id}/values/create', [ValuesController::class, 'create'])->name('values.create');
    Route::post('/{id}/values/create', [ValuesController::class, 'store'])->name('values.create');
    Route::get('/{id}/values/{value}/edit', [ValuesController::class, 'edit'])->name('values.edit');
    Route::post('/{id}/values/{value}/edit', [ValuesController::class, 'update'])->name('values.edit');
    Route::patch('/{id}/values/{value}/edit', [ValuesController::class, 'updateOneField'])->name('values.edit');
    Route::post('/{id}/values/{value}/destroy', [ValuesController::class, 'destroy'])->name('values.destroy');
});

Route::prefix('attribute-groups')->group(function () {
    Route::get('/', [AttributeGroupsController::class, 'index'])->name('attribute-groups.index');
    Route::get('/create', [AttributeGroupsController::class, 'create'])->name('attribute-groups.create');
    Route::post('/create', [AttributeGroupsController::class, 'store'])->name('attribute-groups.create');
    Route::get('/{id}/edit', [AttributeGroupsController::class, 'edit'])->name('attribute-groups.edit');
    Route::post('/{id}/edit', [AttributeGroupsController::class, 'update'])->name('attribute-groups.edit');
    Route::patch('/{id}/edit', [AttributeGroupsController::class, 'updateOneField'])->name('attribute-groups.edit');
    Route::post('/{id}/destroy', [AttributeGroupsController::class, 'destroy'])->name('attribute-groups.destroy');
});
